
ComplexIndexRefraction();
load('veghte_refractiveidx_thief.mat');

figure;
maxfig(gcf,1);
hold on;


% plot(energy,upper_im_avg,'Color',[0.4,0.4,0.4],'LineWidth',1);
area(energy,upper_im_avg,'FaceColor',[0.9,0.9,0.9]);

plot(energy,lower_im_avg,'Color',[0.4,0.4,0.4],'LineWidth',1);
area(energy,lower_im_avg,'FaceColor',[1,1,1]);

plot(energy,im_avg,'k');



plot(660.*ones(8,1),AAE_ktable(:,1),'LineStyle','none','Marker','.','MarkerSize',30,'Color',[0.8,0,0]);
plot(470.*ones(8,1),AAE_ktable(:,2),'LineStyle','none','Marker','.','MarkerSize',30,'Color',[0,0,0.8]);


set(gca,'FontSize',20,'FontWeight','bold',...
	'YTick',[0,0.04,0.08,0.12,0.16,0.2],...
	'XTick',[210,400,600,800,1000],...
	'XTickLabel',{'200','400','600','800','1000'},'Box','off');
xlim([210,1100]);
xlabel('Wavelength (nm)');


%% Absorption Coeff (sigma) and AAE calculations
[~,ridx] = min(abs(energy - 660));
[~,bidx] = min(abs(energy - 470));

sig = 4.*pi.*(im_avg)./energy;
sig = sig .* (1e9 ./ 1e-6);
aae_fromveg = -log(sig(ridx)./sig(bidx))./log(660./470);

sig_up = 4.*pi.*upper_im_avg./energy;
sig_up = sig_up .* (1e9 ./ 1e-6);
aae_fromveg_up = -log(sig_up(ridx)./sig_up(bidx))./log(660./470);

sig_low = 4.*pi.*lower_im_avg./energy;
sig_low = sig_low .* (1e9 ./ 1e-6);
aae_fromveg_low = -log(sig_low(ridx)./sig_low(bidx))./log(660./470);

% figure; plot(energy,sig);